/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.items;

import com.google.common.collect.Multimap;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import noppes.npcs.CustomRegisters;
import noppes.npcs.api.ICustomElement;
import noppes.npcs.api.INbt;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.items.CustomItem;
import noppes.npcs.reflection.item.ItemToolReflection;
import noppes.npcs.util.Util;

public class CustomTool
extends ItemTool
implements ICustomElement {
    protected NBTTagCompound nbtData;
    protected Material collectionMaterial = null;
    protected float speedCollectionMaterial = 1.0f;
    protected ItemStack repairItemStack;
    protected int enchantability = 0;
    protected int harvestLevel = 0;

    public CustomTool(float attackDamageIn, float attackSpeedIn, Item.ToolMaterial materialIn, Set<Block> effectiveBlocksIn, NBTTagCompound nbtItem) {
        super(attackDamageIn, attackSpeedIn, materialIn, effectiveBlocksIn);
        this.nbtData = nbtItem;
        this.setRegistryName("customnpcs", "custom_" + nbtItem.func_74779_i("RegistryName"));
        this.func_77655_b("custom_" + nbtItem.func_74779_i("RegistryName"));
        if (nbtItem.func_150297_b("IsFull3D", 1) && nbtItem.func_74767_n("IsFull3D")) {
            this.func_77664_n();
        }
        if (nbtItem.func_74762_e("MaxStackDamage") > 1) {
            this.func_77656_e(nbtItem.func_74762_e("MaxStackDamage"));
        }
        if (nbtItem.func_150297_b("CollectionMaterial", 10)) {
            this.collectionMaterial = CustomItem.getMaterial(nbtItem.func_74775_l("collectionMaterial").func_74779_i("Material"));
            this.speedCollectionMaterial = nbtItem.func_74775_l("collectionMaterial").func_74760_g("Speed");
        }
        if (nbtItem.func_150297_b("Efficiency", 5)) {
            this.field_77864_a = nbtItem.func_74760_g("Efficiency");
        }
        this.repairItemStack = nbtItem.func_150297_b("RepairItem", 10) ? new ItemStack(nbtItem.func_74775_l("RepairItem")) : materialIn.getRepairItemStack();
        if (nbtItem.func_150297_b("Enchantability", 3)) {
            this.enchantability = nbtItem.func_74762_e("Enchantability");
        }
        if (nbtItem.func_150297_b("EntityDamage", 6)) {
            this.field_77865_bY = (float)nbtItem.func_74769_h("EntityDamage");
        }
        if (nbtItem.func_150297_b("HarvestLevel", 3)) {
            this.harvestLevel = nbtItem.func_74762_e("HarvestLevel");
        }
        if (nbtItem.func_150297_b("ToolClass", 8)) {
            ItemToolReflection.setToolClass(this, nbtItem.func_74779_i("ToolClass"));
        }
        this.func_77637_a(CustomRegisters.tabItems);
    }

    @Override
    public String getCustomName() {
        return this.nbtData.func_74779_i("RegistryName");
    }

    @Override
    public INbt getCustomNbt() {
        return Objects.requireNonNull(NpcAPI.Instance()).getINbt(this.nbtData);
    }

    public float func_150893_a(@Nonnull ItemStack stack, @Nonnull IBlockState state) {
        if (state.func_185904_a() == this.collectionMaterial) {
            return this.speedCollectionMaterial;
        }
        return super.func_150893_a(stack, state);
    }

    public int getHarvestLevel(@Nonnull ItemStack stack, @Nonnull String toolClass, @Nullable EntityPlayer player, @Nullable IBlockState blockState) {
        if (this.harvestLevel > -1) {
            return this.harvestLevel;
        }
        return super.getHarvestLevel(stack, toolClass, player, blockState);
    }

    public boolean func_82789_a(@Nonnull ItemStack toRepair, @Nonnull ItemStack repair) {
        ItemStack mat = this.repairItemStack;
        if (this.repairItemStack.func_190926_b()) {
            mat = this.field_77862_b.getRepairItemStack();
        }
        if (!mat.func_190926_b() && OreDictionary.itemMatches((ItemStack)mat, (ItemStack)repair, (boolean)false)) {
            return true;
        }
        return super.func_82789_a(toRepair, repair);
    }

    @Nonnull
    public Multimap<String, AttributeModifier> func_111205_h(@Nonnull EntityEquipmentSlot equipmentSlot) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)this.field_77865_bY, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", (double)this.field_185065_c, 0));
        }
        return multimap;
    }

    public int func_77619_b() {
        if (this.enchantability > 0) {
            return this.enchantability;
        }
        return super.func_77619_b();
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
        if (tab != CustomRegisters.tabItems && tab != CreativeTabs.field_78027_g) {
            return;
        }
        if (this.nbtData != null && this.nbtData.func_150297_b("ShowInCreative", 1) && !this.nbtData.func_74767_n("ShowInCreative")) {
            return;
        }
        items.add((Object)new ItemStack((Item)this));
        if (tab == CustomRegisters.tabItems) {
            Util.instance.sort(items);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return this.field_77789_bW;
    }

    @Override
    public int getType() {
        if (this.nbtData != null && this.nbtData.func_150297_b("BlockType", 1)) {
            return this.nbtData.func_74771_c("BlockType");
        }
        return 2;
    }
}

